package cn.com.duiba.tuia.ecb.center.api.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * cpd 下载类广告的基础数据
 * @author lichao 2019/4/8
 */
@ApiModel
public class CpdDatasReq implements Serializable {

    //设备id
    @ApiModelProperty("设备id")
    private String deviceId;

    //用户ua
    @ApiModelProperty("用户ua")
    private String userAgent;

    //ip
    private String ip;

    //wifi,4G,3G,2G,other,unknown
    @ApiModelProperty("使用的网络 wifi,4G,3G,2G,other,unknown")
    private String networkType;

    @ApiModelProperty("运营商 0:未知; 1:中国移动; 2:中国电信; 3:中国联通; 4:其他运营商")
    private Integer carrior = 0;

    @ApiModelProperty("手机imei")
    private String imei;

    @ApiModelProperty("手机mac地址")
    private String mac;

    @ApiModelProperty("手机SIM卡号")
    private String imsi;

    @ApiModelProperty("手机设备id")
    private String androidId;

    @ApiModelProperty("手机厂商")
    private String vendor;

    @ApiModelProperty("手机品牌")
    private String brand;

    @ApiModelProperty("手机型号")
    private String model;

    @ApiModelProperty("设备类型---0:未知; 1:手机; 2:平板; 3:智能TV")
    private Integer deviceType;

    @ApiModelProperty("屏幕dpi")
    private String dpi;

    @ApiModelProperty("屏幕尺寸宽x 高（800x1223）")
    private String screenSize;

    @ApiModelProperty("屏幕方向---0:未知; 1:竖屏; 2:横屏")
    private Integer orientation = 0;

    @ApiModelProperty("操作系统版本号")
    private String osVersion;

    @ApiModelProperty("操作系统版本号, 采集自Build.VERSION.SDK_INT")
    private String versionInt;

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getUserAgent() {
        return userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getNetworkType() {
        return networkType;
    }

    public void setNetworkType(String networkType) {
        this.networkType = networkType;
    }

    public Integer getCarrior() {
        return carrior;
    }

    public void setCarrior(Integer carrior) {
        this.carrior = carrior;
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getMac() {
        return mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public String getImsi() {
        return imsi;
    }

    public void setImsi(String imsi) {
        this.imsi = imsi;
    }


    public String getAndroidId() {
        return androidId;
    }

    public void setAndroidId(String androidId) {
        this.androidId = androidId;
    }

    public String getVendor() {
        return vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Integer getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(Integer deviceType) {
        this.deviceType = deviceType;
    }

    public String getDpi() {
        return dpi;
    }

    public void setDpi(String dpi) {
        this.dpi = dpi;
    }

    public String getScreenSize() {
        return screenSize;
    }

    public void setScreenSize(String screenSize) {
        this.screenSize = screenSize;
    }

    public Integer getOrientation() {
        return orientation;
    }

    public void setOrientation(Integer orientation) {
        this.orientation = orientation;
    }

    public String getOsVersion() {
        return osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getVersionInt() {
        return versionInt;
    }

    public void setVersionInt(String versionInt) {
        this.versionInt = versionInt;
    }
}
