package cn.com.duiba.tuia.ecb.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.cpd.dto.CPDListDetailDto;
import cn.com.duiba.tuia.ecb.center.cpd.req.CpdAppReq;
import cn.com.duiba.tuia.ecb.center.cpd.req.CpdListReq;

import java.util.List;

/**
 * cpd 应用试玩的service
 * @author lichao 2019/4/4
 */
@AdvancedFeignClient
public interface RemoteCpdService {

    /**
     * 获取应用试玩列表
     * @param req
     * @return
     */
    List<CPDListDetailDto> getList(CpdListReq req);

    /**
     * 获取活跃任务列表
     * @param req
     * @return
     */
    List<CPDListDetailDto> missionList(CpdListReq req);

    /**
     * 下载开始,目前只有tuiaCpC有效
     * @param cpdAppReq
     * @return
     */
    Boolean downStart(CpdAppReq cpdAppReq);
}
