package cn.com.duiba.tuia.ecb.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.dto.WithdrawOrderDto;
import cn.com.duiba.tuia.ecb.center.req.WithdrawApplyReq;

import java.util.List;
import java.util.Map;

/**
 * Created by xuefeng on 2019/4/8.
 */
@AdvancedFeignClient
public interface RemoteWithdrawService {

    /**
     * 提现申请
     * @param withdrawApplyReq
     * @return
     */
    Long apply(WithdrawApplyReq withdrawApplyReq);

    /**
     * 通过零钱流水号查询订单
     *
     * @param changeSerialNumbers
     * @return map中key为零钱流水号，value为订单详情；不包括不存在的记录
     */
    Map<Long, WithdrawOrderDto> queryByChangeSerialNumber(List<Long> changeSerialNumbers);
}
