package cn.com.duiba.tuia.ecb.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * Created by xuefeng on 2019/4/8.
 */
public enum ChangeIncomeCode implements ChangeTradeCode {

    /**
     * 签到奖励
     */
    SIGN_IN(1, "签到奖励"),

    /**
     * 试玩奖励
     */
    TRY_PLAY_REWARD(2, "试玩奖励"),
    ;


    private Integer code;

    private String desc;

    private static final Map<Integer, ChangeIncomeCode> CACHE = Maps.uniqueIndex(Arrays.asList(ChangeIncomeCode.values()),
            ChangeIncomeCode::getCode);

    ChangeIncomeCode(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static ChangeIncomeCode get(Integer code) {
        return CACHE.get(code);
    }
}
