package cn.com.duiba.tuia.ecb.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.cpd.dto.CPDAppDetailDto;
import cn.com.duiba.tuia.ecb.center.cpd.dto.CPDListDetailDto;
import cn.com.duiba.tuia.ecb.center.cpd.dto.CpdAcceptDto;
import cn.com.duiba.tuia.ecb.center.cpd.req.CpdAppReq;
import cn.com.duiba.tuia.ecb.center.cpd.req.CpdDatasReq;
import cn.com.duiba.tuia.ecb.center.cpd.req.CpdListReq;

import java.util.Date;
import java.util.List;

/**
 * cpd 应用试玩的service
 * @author lichao 2019/4/4
 */
@AdvancedFeignClient
public interface RemoteCpdService {

    /**
     * 获取应用试玩列表
     * @param req
     * @return
     */
    List<CPDListDetailDto> getList(CpdListReq req) throws BizException;

    /**
     * app详情
     * @param cpdAppReq
     * @return
     * @throws BizException
     */
    CPDAppDetailDto appDetail(CpdAppReq cpdAppReq) throws BizException;

    /**
     * 获取活跃任务列表
     * 获取活跃任务列表-今天
     * @param req
     * @return
     */
    List<CPDListDetailDto> missionList(CpdListReq req) throws BizException ;

    /**
     * 获取活跃任务列表-指定时间
     * @param req
     * @param now
     * @return
     * @throws BizException
     */
    List<CPDListDetailDto> missionListWithTime(CpdListReq req,Date now) throws BizException;

    /**
     * 下载开始,目前只有tuiaCpC有效
     * @param cpdAppReq
     * @return
     */
    Boolean downStart(CpdAppReq cpdAppReq) throws BizException;


    /**
     * 开始试玩
     * @param req
     */
    void tryPlayStart(CpdAppReq req);

    /**
     * 领取奖励
     * @param cpdAppReq
     * @return
     */
    CpdAcceptDto acceptApp(CpdAppReq cpdAppReq, CpdDatasReq datas) throws BizException;




}
