package cn.com.duiba.tuia.ecb.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.dto.MoneyTreeAdReq;
import cn.com.duiba.tuia.ecb.center.dto.MoneyTreeDetailDto;
import cn.com.duiba.tuia.ecb.center.dto.MoneyTreePrizeDto;

/**
 * 摇钱树
 * Created by xuefeng on 2019/4/23.
 */
@AdvancedFeignClient
public interface RemoteMoneyTreeService {

    /**
     * 查询摇钱树详情
     * @param req
     * @return
     */
    MoneyTreeDetailDto detail(MoneyTreeAdReq req);

    /**
     * 种树
     * @param req
     * @return
     */
    Boolean plant(MoneyTreeAdReq req);

    /**
     * 领取奖励
     * @param userId
     * @param index
     * @return
     */
    MoneyTreePrizeDto pick(Long userId, Integer index);

    /**
     * 领取奖励
     * @param req
     * @return
     */
    Boolean water(MoneyTreeAdReq req);

    /**
     * 用户加水
     * @param userId
     * @param waterNum
     * @return
     */
    Boolean addOwnWater(Long userId, Long waterNum);
}
