package cn.com.duiba.tuia.ecb.center.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

@ApiModel("app对象")
public class CpdAppDto implements Serializable {

    @ApiModelProperty("应用id")
    private Long id;

    @ApiModelProperty("应用来源,1:推啊cpc 2:推啊直客")
    private Integer appSource;

    @ApiModelProperty("应用适用的场景 -1 全部 1激励广告b端")
    private Integer appApply;

    @ApiModelProperty("应用名称")
    private String appName;

    @ApiModelProperty("应用描述")
    private String appDesc;

    @ApiModelProperty("应用logo")
    private String appLogo;

    @ApiModelProperty("应用安装地址")
    private String appUrl;

    @ApiModelProperty("应用包名")
    private String appPackage;

    @ApiModelProperty("应用大小")
    private String appSize;

    @ApiModelProperty("app状态（0:停用;1:正常;）")
    private Integer appStatus;

    @ApiModelProperty("广告计划ID")
    private Long chargeAdvertId;

    @ApiModelProperty("预算上限类型（0：无上限；1：发放次数；2：奖励金额）")
    private Integer chargeLimitType;

    @ApiModelProperty("预算上限,类型为1时表示次数；为2时表示金额，单位分")
    private Integer chargeLimit;

    @ApiModelProperty("奖励提示")
    private String rewardTips;

    @ApiModelProperty("app最短体验时长，单位：秒")
    private Integer rewardExpTime;

    @ApiModelProperty("奖励分布（[10,20,30]）")
    private String rewardSet;

    private Date gmtCreate;

    private Date gmtModified;

    @ApiModelProperty("排序")
    private Integer appOrder;

    @ApiModelProperty("扩展字段")
    private String extInfo;

    @ApiModelProperty("用于标记cpc价格")
    private String cpcMark;

    @ApiModelProperty("来源备注")
    private String sourceMark;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getAppSource() {
        return appSource;
    }

    public void setAppSource(Integer appSource) {
        this.appSource = appSource;
    }

    public Integer getAppApply() {
        return appApply;
    }

    public void setAppApply(Integer appApply) {
        this.appApply = appApply;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppDesc() {
        return appDesc;
    }

    public void setAppDesc(String appDesc) {
        this.appDesc = appDesc;
    }

    public String getAppLogo() {
        return appLogo;
    }

    public void setAppLogo(String appLogo) {
        this.appLogo = appLogo;
    }

    public String getAppUrl() {
        return appUrl;
    }

    public void setAppUrl(String appUrl) {
        this.appUrl = appUrl;
    }

    public String getAppPackage() {
        return appPackage;
    }

    public void setAppPackage(String appPackage) {
        this.appPackage = appPackage;
    }

    public String getAppSize() {
        return appSize;
    }

    public void setAppSize(String appSize) {
        this.appSize = appSize;
    }

    public Integer getAppStatus() {
        return appStatus;
    }

    public void setAppStatus(Integer appStatus) {
        this.appStatus = appStatus;
    }

    public Long getChargeAdvertId() {
        return chargeAdvertId;
    }

    public void setChargeAdvertId(Long chargeAdvertId) {
        this.chargeAdvertId = chargeAdvertId;
    }

    public Integer getChargeLimitType() {
        return chargeLimitType;
    }

    public void setChargeLimitType(Integer chargeLimitType) {
        this.chargeLimitType = chargeLimitType;
    }

    public Integer getChargeLimit() {
        return chargeLimit;
    }

    public void setChargeLimit(Integer chargeLimit) {
        this.chargeLimit = chargeLimit;
    }

    public String getRewardTips() {
        return rewardTips;
    }

    public void setRewardTips(String rewardTips) {
        this.rewardTips = rewardTips;
    }

    public Integer getRewardExpTime() {
        return rewardExpTime;
    }

    public void setRewardExpTime(Integer rewardExpTime) {
        this.rewardExpTime = rewardExpTime;
    }

    public String getRewardSet() {
        return rewardSet;
    }

    public void setRewardSet(String rewardSet) {
        this.rewardSet = rewardSet;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getAppOrder() {
        return appOrder;
    }

    public void setAppOrder(Integer appOrder) {
        this.appOrder = appOrder;
    }

    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public String getCpcMark() {
        return cpcMark;
    }

    public void setCpcMark(String cpcMark) {
        this.cpcMark = cpcMark;
    }

    public String getSourceMark() {
        return sourceMark;
    }

    public void setSourceMark(String sourceMark) {
        this.sourceMark = sourceMark;
    }
}
