package cn.com.duiba.tuia.ecb.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.dto.*;

import java.util.List;

/**
 * 媒体相关统计
 * Created by xuefeng on 2019/6/3.
 */
@AdvancedFeignClient
public interface RemoteMediaStatService {

    /**
     * 媒体维度查询资金明细
     * @param query
     * @return
     */
    PageQueryResultDto<SlotFundDto> mediaFund(MediaAppQuery query);

    /**
     * 广告位维度查询资金明细
     * @param appId
     * @return
     */
    List<SlotFundDto> slotFund(Long appId);

    /**
     * 广告位维度查询资金明细
     * @param query
     * @return
     */
    PageQueryResultDto<SlotFundDto> slotDailFund(MediaAppQuery query);

    /**
     * 更新
     * @param slotFundDto
     * @return
     */
    Boolean updateFund(SlotFundDto slotFundDto);

    /**
     * 广告位维度留存数据
     * @param query
     * @return
     */
    List<SlotLeaveDto> slotLeave(MediaSlotQuery query);
}
