package cn.com.duiba.tuia.ecb.center.common.enums;

import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author huangruodan
 * @version 创建时间：2020/3/16 5:32 下午
 */
public enum ConnectionType {
    DEFAULT(0, "未知"),
    SECOND_G(2, "2G"),
    THREE_G(3, "3G"),
    FOUR_G(4, "4G"),
    FIVE_G(5, "5G"),
    WIFI(100, "WIFI"),
    ETHERNET(101, "ETHERNET"),
    NEW_TYPE(999, "NEW_TYPE");

    private Integer type;

    private String desc;


    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    ConnectionType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static ConnectionType getByType(Integer type) {
        List<ConnectionType> list = Lists.newArrayList(ConnectionType.values())
                .stream()
                .filter(input -> input.type.equals(type))
                .collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return ConnectionType.DEFAULT;
    }
}
