package cn.com.duiba.tuia.ecb.center.exception;

/**
 * @author ElinZhou
 * @version $Id: ErrorCode.java , v 0.1 2017/12/28 下午3:24 ElinZhou Exp $
 */
public enum ErrorCode {
    SYSTEM_EXCEPTION("9999999", "系统异常"),
    USER_NOT_EXIST("0300001", "用户不存在"),
    LACK_OF_CHANGE_BALANCE("0300002", "零钱余额不足"),
    APP_NOT_EXIST("0300003", "当前应用已下架，记得早些领取哦"),
    APP_STATUS_ERROR("0300004", "该应用未达到领取条件"),
    APP_TODAY_ACEPTED("0300005", "你已经领取过这份奖励啦~"),
    APP_EXPIRE("0300006", "这份奖励已过期~"),
    APP_ACCEPT_ERROR("0300007", "你的奖励领取异常~"),
    WITHDRAW_UPDATE_ERROR("0310000", "提现更新状态异常"),

    /*
     *  工具类赚钱页错误码
     */
    // 通用
    E0400001("0400001", "参数为空"),

    // 签到
    E0401001("0401001", "没有补签机会了哦~"),
    E0401002("0401002", "用户未初始化"),
    E0401003("0401003", "只能补签当前签到周期时间"),

    // 收益
    E0402001("0402001", "时间戳校验失败"),
    E0402002("0402002", "签名校验失败"),
    E0402003("0402003", "用户校验失败"),
    E0402004("0402004", "token 校验失败"),
    E0402005("0402005", "超过收益上限"),
    E0402006("0402006", "重复请求"),
    E0402007("0402007", "没查到收益信息"),
    E0402008("0402008", "金额不足，赶紧攒金币哦"),
    E0402009("0402009", "获取用户收益信息失败"),
    E0402010("0402010", "用户提现失败"),
    E0402011("0402011", "用户提现失败"),
    E0402012("0402012", "获取提现详情失败"),
    E0402013("0402013", "获取正在提现的订单失败"),
    E0402014("0402014", "未查到提现记录"),
    E0402015("0402015", "提现记录与用户信息不一致"),
    E0402016("0402016", "获取提现信息失败"),
    E0402017("0402017", "获取提现配置失败"),
    // 用户
    E0403001("0403001", "未查询到用户信息"),
    E0403002("0403002","页面初始化异常"),

    // E041 开头为摇钱树相关ERROR
    E0404001("0404001", "用户信息未找到"),
    E0404002("0404002", "用户已经存在"),

    E0405001("0405001","未查询到该活动的配置");

    private String code;

    private String description;

    ErrorCode(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

}
