package cn.com.duiba.tuia.ecb.center.mix.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.mix.dto.MixWithdrawAuditRecordDTO;
import cn.com.duiba.tuia.ecb.center.mix.dto.MixWithdrawImmediatelyDTO;
import cn.com.duiba.tuia.ecb.center.mix.req.MixUserReq;
import cn.com.duiba.tuia.ecb.center.mix.req.MixWithdrawDetailReq;
import cn.com.duiba.tuia.ecb.center.mix.req.MixWithdrawReq;

/**
 * @Author: xianhongwei
 * @Time: 2020-01-13 14:47
 * @Desc:
 */
@AdvancedFeignClient
public interface RemoteMixWithdrawService {

    /**
     * 预提现  用户提现资格校验
     */
    MixWithdrawAuditRecordDTO preWithdraw(MixWithdrawReq req) throws BizException;

    /**
     * 提现接口，
     */
    MixWithdrawAuditRecordDTO withdraw(MixWithdrawReq req) throws BizException;

    /**
     * 获取提现详情
     *
     * @param req
     * @return
     */
    MixWithdrawAuditRecordDTO getWithdrawDetail(MixWithdrawDetailReq req) throws BizException;

    /**
     * 获取用户正在审核的提现
     *
     * @param mixUserReq
     * @return
     */
    MixWithdrawAuditRecordDTO selectUserCheckingWithdraw(MixUserReq mixUserReq) throws BizException;


    /**
     * 立即提现接口
     *
     * @param mixUserReq
     * @return
     * @throws BizException
     */
    MixWithdrawImmediatelyDTO getWithdrawImmediately(MixUserReq mixUserReq) throws BizException;


//    List<FarmWithdrawRecordDto> selectRecordByUserId(Long userId);

//    int insertRecord(FarmWithdrawRecordDto withDrawRecord);
//
//    int updateRecord(FarmWithdrawRecordDto withDrawRecord);
//
//    String selectOrder(MixUserReq req);
//
//    List<FarmWithdrawRecordDto> selectRecordBy(MixUserReq req);
}
