package cn.com.duiba.tuia.ecb.center.mix.dto.clock;

import cn.com.duiba.tuia.ecb.center.mix.dto.MixClockSignInListDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * @author lijicong
 * @since 2020-04-26
 */
@Setter
@Getter
public class MixClockIndexDTO implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "是否新用户")
    private Boolean isNewUser;

    @ApiModelProperty(value = "时间段状态 1:00-06点 2:06-10点 3:10-12点 4:12-24点")
    private Integer timeSlot;

    @ApiModelProperty(value = "距离下一个时间段的秒数")
    private Integer nextTime;

    @ApiModelProperty(value = "每日消耗金币")
    private Integer consumeAmount;

    @ApiModelProperty(value = "上一期-昨天/历史")
    private MixClockPeriodDTO before;

    @ApiModelProperty(value = "当前期-今天")
    private MixClockPeriodDTO current;

    @ApiModelProperty(value = "下一期-明天")
    private MixClockPeriodDTO next;

    @ApiModelProperty(value = "打卡战况列表")
    private List<MixClockSignInListDto> signList;

}
