package cn.com.duiba.tuia.ecb.center.mix.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.mix.dto.MixClockSignInListDto;
import cn.com.duiba.tuia.ecb.center.mix.dto.clock.MixClockInDto;
import cn.com.duiba.tuia.ecb.center.mix.dto.clock.MixClockIndexDTO;
import cn.com.duiba.tuia.ecb.center.mix.dto.clock.MixClockPeriodDTO;
import cn.com.duiba.tuia.ecb.center.mix.req.MixClockPeriodReq;
import cn.com.duiba.tuia.ecb.center.mix.req.MixClockSignUpReq;
import cn.com.duiba.tuia.ecb.center.mix.req.MixUserReq;

import java.util.List;

/**
 * Created by dylan on 2020/4/24.
 */
@AdvancedFeignClient
public interface RemoteMixClockService {

    /**
     * 查询战况瓜分金币信息
     * @param activityId
     * @param appId
     * @param periodNo
     * @return
     */
    List<MixClockSignInListDto> querySignInRecord(String activityId, String appId, String periodNo) throws BizException;

    /**
     * 早起签到报名接口
     * @param mixClockSignUpReq
     * @return
     */
    void toSignUp(MixClockSignUpReq mixClockSignUpReq) throws BizException;

    /**
     * 早起签到打卡接口
     * @param mixClockSignUpReq
     * @return
     */
    MixClockInDto clockIn(MixClockSignUpReq mixClockSignUpReq) throws BizException;

    /**
     * 领取金币接口
     * @param mixUserReq
     * @throws BizException
     */
    void getGold(MixUserReq mixUserReq) throws BizException;

    /**
     * 入口提示展示接口
     * @param mixUserReq
     * @return
     * @throws BizException
     */
    String showTips(MixUserReq mixUserReq) throws BizException;

    /**
     * 初始接口
     * @param req
     * @return
     */
    MixClockIndexDTO init(MixUserReq req) throws BizException;

    /**
     * 每期详情
     * @param req
     * @return
     * @throws BizException
     */
    MixClockPeriodDTO detail(MixClockPeriodReq req) throws BizException;

}
