package cn.com.duiba.tuia.ecb.center.happy.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.happy.dto.HappyClearMediaConfigDTO;
import cn.com.duiba.tuia.ecb.center.happy.dto.HappyClearPropConfigDTO;
import cn.com.duiba.tuia.ecb.center.happy.dto.HappyClearShoppingDTO;
import cn.com.duiba.tuia.ecb.center.happy.dto.HappyClearSignDTO;

import java.util.List;

@AdvancedFeignClient
public interface RemoteHappyClearConfigService {

    Boolean saveMediaConfig(HappyClearMediaConfigDTO happyClearMediaConfigDTO) throws BizException;

    Boolean deleteMediaConfig(Long appId) throws BizException;

    HappyClearShoppingDTO getExchangeConfig(Long appId) throws BizException;

    HappyClearMediaConfigDTO getMedisConfig(Long appId) throws BizException;

    Boolean saveSignConfig(HappyClearSignDTO happyClearSignDTO) throws BizException;

    Boolean insertBatchSignConfig(List<HappyClearSignDTO> happyClearSignDTOS) throws BizException;

    Boolean deleteSignConfigByAppId(Long appId) throws BizException;

    Boolean deleteSignConfigById(Long id) throws BizException;

    Boolean savePropConfig(HappyClearPropConfigDTO clearPropConfigDTO) throws BizException;

    Boolean insertBatchPropConfig(List<HappyClearPropConfigDTO> clearPropConfigDTOS) throws BizException;

    Boolean deletePropConfigByAppId(Long appId) throws BizException;

    Boolean deletePropConfigById(Long id) throws BizException;
}
