package cn.com.duiba.tuia.ecb.center.video.remoteservice.video;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.video.dto.video.*;

import java.util.List;

/**
 * 激励视频
 * Created by xuefeng on 2019/6/11.
 */
@AdvancedFeignClient
public interface RemoteVideoService {

    /**
     * 获取视频列表
     * @param videoListReq
     * @return
     */
    List<VideoDto> getList(VideoListQuery videoListReq);

    /**
     * 开始播放
     * @param videoSingleQuery
     * @return
     */
    Boolean start(VideoSingleQuery videoSingleQuery);

    /**
     * 播放结束
     * @param videoSingleQuery
     * @return
     */
    Boolean finish(VideoSingleQuery videoSingleQuery);

    /**
     * 下载
     * @param videoSingleQuery
     * @return
     */
    Boolean download(VideoSingleQuery videoSingleQuery);

    /**
     * 查询特定视频素材
     * @param videoSingleQuery
     * @return
     */
    VideoDto getOne(VideoSingleQuery videoSingleQuery);

    /**
     * 操作
     * @param videoSingleQuery
     * @return
     */
    Boolean action(VideoSingleQuery videoSingleQuery);

    /**
     * 混投配置
     * @param videoListQuery
     * @return
     */
    Integer floorConfig(VideoListQuery videoListQuery);

    /**
     * 保底链接
     * @param videoListQuery
     * @return
     */
    String floorUrl(VideoListQuery videoListQuery);

    /**
     * 保底视频
     * @param
     * @return
     */
    List<VideoDto> floorVideos(VideoListQuery videoListQuery);

    /**
     * 活动直投券点击日志dto
     * @param req
     * @return
     */
    Boolean reportClick (VideoReportClickDto req);


    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //管理端

    /**
     * 统计数量
     * @return
     */
    Long getCount(VideoPageQuery query);

    /**
     * 分页查询
     * @return
     */
    List<VideoDto> getPageList(VideoPageQuery query);

    /**
     * 添加／更新视频
     * @param videoDto
     * @return
     */
    Boolean addVideo(VideoDto videoDto);

    /**
     * 删除视频
     * @param id
     * @return
     */
    Boolean delete(Long id);
}
