package cn.com.duiba.tuia.ecb.center.mix.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.mix.dto.MixLastDayIncomeDto;
import cn.com.duiba.tuia.ecb.center.mix.dto.MixSignInConfigDto;
import cn.com.duiba.tuia.ecb.center.mix.dto.MixSignInDto;
import cn.com.duiba.tuia.ecb.center.mix.dto.MixSignInInfoDto;
import cn.com.duiba.tuia.ecb.center.mix.req.MixReplenishSignInReq;
import cn.com.duiba.tuia.ecb.center.mix.req.MixSignInReq;

/**
 * RemoteMixSignInService
 *
 * @author jiangshikui
 * @date 2020/1/9
 **/
@AdvancedFeignClient
public interface RemoteMixSignInService {

    /**
     * 用户签到
     *
     * @param req req
     * @return MixSignInDto
     * @throws BizException BizException
     */
    MixSignInDto doSignIn(MixSignInReq req) throws BizException;

    /**
     * 用户补签
     *
     * @param req MixReplenishSignInReq
     * @return MixSignInDto
     * @throws BizException BizException
     */
    MixSignInDto replenishSignIn(MixReplenishSignInReq req) throws BizException;

    /**
     * 查询签到信息
     *
     * @param req MixSignInReq
     * @return MixSignInInfoDto
     * @throws BizException BizException
     */
    MixSignInInfoDto signInInfo(MixSignInReq req) throws BizException;

    /**
     * 查询昨日收益接口
     *
     * @param req req
     * @return MixLastDayIncomeDto
     * @throws BizException BizException
     */
    MixLastDayIncomeDto lastDayIncome(MixSignInReq req) throws BizException;

    /**
     * 更新签到相关配置
     *
     * @param activityId 活动id
     * @param config 配置
     * @return 是否配置成功
     */
    Boolean updateSignInConfig(Long activityId, MixSignInConfigDto config) throws BizException;

    /**
     * 查询签到配置
     *
     * @param activityId 活动id
     * @return 签到配置
     */
    MixSignInConfigDto querySignInConfig(Long activityId) throws BizException;
}
