package cn.com.duiba.tuia.ecb.center.mix.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.mix.dto.MixMissionDto;
import cn.com.duiba.tuia.ecb.center.mix.dto.MixMissionTemplateDto;
import cn.com.duiba.tuia.ecb.center.mix.req.MixMissionBindReq;
import cn.com.duiba.tuia.ecb.center.mix.req.MixMissionTemplateReq;

import java.util.List;

/**
 * RemoteMixMissionConfigService
 *
 * @author jiangshikui
 * @date 2020/1/15
 **/
@AdvancedFeignClient
public interface RemoteMixMissionConfigService {

    /**
     * 查询任务配置
     *
     * @param missionTemplateId 任务模板id
     * @return 任务配置
     */
    List<MixMissionDto> getMissionConfig(Long missionTemplateId) throws BizException;

    /**
     * 更新支付宝直投广告配置
     * @param id 广告id
     * @return Boolean
     * @throws BizException BizException
     */
    Boolean updateAliPayDirectInvestmentConfig(Long id) throws BizException;

    /**
     * 获取支付宝直投页广告配置
     * @return id
     * @throws BizException BizException
     */
    Long getAliPayDirectInvestmentConfig() throws BizException;

    /**
     * 绑定活动和任务模板
     * @param req
     * @return Boolean
     * @throws BizException BizException
     */
    Boolean bindActivityAndMissionTemplate(MixMissionBindReq req) throws BizException;

    /**
     * 查询任务模板列表
     *
     * @return List<MixMissionTemplateDto>
     * @throws BizException BizException
     */
    List<MixMissionTemplateDto> getMissionTemplateList() throws BizException;

    /**
     * 更新任务配置
     * @param req req
     * @return Long 任务模板id
     * @throws BizException BizException
     */
    Long updateMissionTemplate(MixMissionTemplateReq req) throws BizException;

    /**
     * 查询活动绑定的任务模板
     *
     * @param activityId 活动id
     * @return 任务模板id
     */
    Long queryMissionTemplateBind(Long activityId) throws BizException;
}
