/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ecb.center.mix.dto;

import cn.com.duiba.tuia.ecb.center.mix.dto.BaseDto;
import java.io.Serializable;
import java.util.List;

public class PageDTO<T extends Serializable>
extends BaseDto {
    private static final long serialVersionUID = -4614140539293496037L;
    private int pageSize;
    private int totalCount;
    private int totalPage;
    private int currentPage;
    private int offset;
    private int max;
    private List<T> list;
    private T total;

    private PageDTO() {
    }

    public PageDTO(int totalAmount, List<T> list, int offset, int max) {
        this.totalCount = totalAmount;
        this.list = list;
        this.offset = offset;
        this.max = max;
        this.pageSize = max;
        this.currentPage = offset / max + 1;
        this.totalPage = this.calTotalPage(this.pageSize);
    }

    public PageDTO(int currentPage, int pageSize) {
        this.max = pageSize;
        this.currentPage = currentPage;
        this.pageSize = pageSize;
        this.offset = pageSize * (currentPage - 1);
    }

    private int calTotalPage(int pageSize) {
        if (this.totalCount < 0) {
            return 0;
        }
        return (this.totalCount + 1) / pageSize;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public T getTotal() {
        return this.total;
    }

    public void setTotal(T total) {
        this.total = total;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }
}

