package cn.com.duiba.tuia.ecb.center.happy.rsp;

import cn.com.duiba.tuia.ecb.center.happy.dto.HappyClearSignDTO;
import cn.com.duiba.tuia.ecb.center.happy.dto.SignRewardInfoDTO;
import cn.com.duiba.tuia.ecb.center.happy.enums.SignRewardTypeEnum;
import com.google.common.collect.Maps;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class HappyClearSignRsp implements Serializable {
    private static final long serialVersionUID = 7665681488818893441L;


    /**
     * 今日签到状态
     */
    private Boolean todaySigned = false;

    /**
     * 本月已签到集合
     */
    private Map<String, Boolean> monthSignedMap;

    /**
     * 本月已签到集合
     */
    private Map<String, Integer> monthSignCreditsMap;

    /**
     * 补签集合
     */
    private Map<String, Boolean> monthResignedMap;

    /**
     * 连续签到天数
     */
    private Integer continueDay;

    /**
     * 今日签到可得积分
     */
    private Integer credits;

    /**
     * 累计签到获得积分
     */
    private Integer totalCredits;

    /**
     * 签到奖励集合，类型加奖励
     */
    private Map<SignRewardTypeEnum, SignRewardInfoDTO> rewardMap = Maps.newHashMap();

    /**
     * 明日签到可得积分
     */
    private Integer creditsTomorrow;

    /**
     * 今日签到可得抽奖次数
     */
    private Integer activityCount;

    /**
     * 明日签到可得抽奖次数
     */
    private Integer activityCountTomorrow;

    /**
     * 用户第一次签到的时间
     */
    private Date firstSignDate;

    /**
     * 用户在该签到下面坚持的天数
     */
    private Integer lastDays;
    /**
     * 是否有累积奖励
     */
    private Boolean hasAcmReward;
    /**
     * 周期内累计签到天数（包含补签）
     */
    private Integer acmDays;
    /**
     * 实际累积签到天数（包含补签）
     */
    private Integer acmDay;
    /**
     * 剩余补签次数
     */
    private Integer resignCount;

    /**
     * 周期内最大连续签到天数
     */
    private Integer maxContinueDay;

    /**
     * 周期天数,周期签到及固定时间自定义周期签到时有效
     */
    private Integer cusCirDays;

    /**
     * 今日签到奖励红包金额，单位：分
     */
    private Integer redCount;

    /**
     * 明日签到奖励红包金额，单位：分
     * @return
     */
    private Integer redCountTomorrow;

    /**
     * 今日奖励奖品池抽奖机会
     */
    private Integer prizeChance;

    /**
     * 明日奖励奖品池抽奖机会
     */
    private Integer prizeChanceTomorrow;


    private List<HappyClearSignDTO> signList;

    public Boolean getTodaySigned() {
        return todaySigned;
    }

    public void setTodaySigned(Boolean todaySigned) {
        this.todaySigned = todaySigned;
    }

    public Map<String, Boolean> getMonthSignedMap() {
        return monthSignedMap;
    }

    public void setMonthSignedMap(Map<String, Boolean> monthSignedMap) {
        this.monthSignedMap = monthSignedMap;
    }

    public Map<String, Integer> getMonthSignCreditsMap() {
        return monthSignCreditsMap;
    }

    public void setMonthSignCreditsMap(Map<String, Integer> monthSignCreditsMap) {
        this.monthSignCreditsMap = monthSignCreditsMap;
    }

    public Map<String, Boolean> getMonthResignedMap() {
        return monthResignedMap;
    }

    public void setMonthResignedMap(Map<String, Boolean> monthResignedMap) {
        this.monthResignedMap = monthResignedMap;
    }

    public Integer getContinueDay() {
        return continueDay;
    }

    public void setContinueDay(Integer continueDay) {
        this.continueDay = continueDay;
    }

    public Integer getCredits() {
        return credits;
    }

    public void setCredits(Integer credits) {
        this.credits = credits;
    }

    public Integer getTotalCredits() {
        return totalCredits;
    }

    public void setTotalCredits(Integer totalCredits) {
        this.totalCredits = totalCredits;
    }

    public Map<SignRewardTypeEnum, SignRewardInfoDTO> getRewardMap() {
        return rewardMap;
    }

    public void setRewardMap(Map<SignRewardTypeEnum, SignRewardInfoDTO> rewardMap) {
        this.rewardMap = rewardMap;
    }

    public Integer getCreditsTomorrow() {
        return creditsTomorrow;
    }

    public void setCreditsTomorrow(Integer creditsTomorrow) {
        this.creditsTomorrow = creditsTomorrow;
    }

    public Integer getActivityCount() {
        return activityCount;
    }

    public void setActivityCount(Integer activityCount) {
        this.activityCount = activityCount;
    }

    public Integer getActivityCountTomorrow() {
        return activityCountTomorrow;
    }

    public void setActivityCountTomorrow(Integer activityCountTomorrow) {
        this.activityCountTomorrow = activityCountTomorrow;
    }

    public Date getFirstSignDate() {
        return firstSignDate;
    }

    public void setFirstSignDate(Date firstSignDate) {
        this.firstSignDate = firstSignDate;
    }

    public Integer getLastDays() {
        return lastDays;
    }

    public void setLastDays(Integer lastDays) {
        this.lastDays = lastDays;
    }

    public Boolean getHasAcmReward() {
        return hasAcmReward;
    }

    public void setHasAcmReward(Boolean hasAcmReward) {
        this.hasAcmReward = hasAcmReward;
    }

    public Integer getAcmDays() {
        return acmDays;
    }

    public void setAcmDays(Integer acmDays) {
        this.acmDays = acmDays;
    }

    public Integer getAcmDay() {
        return acmDay;
    }

    public void setAcmDay(Integer acmDay) {
        this.acmDay = acmDay;
    }

    public Integer getResignCount() {
        return resignCount;
    }

    public void setResignCount(Integer resignCount) {
        this.resignCount = resignCount;
    }

    public Integer getMaxContinueDay() {
        return maxContinueDay;
    }

    public void setMaxContinueDay(Integer maxContinueDay) {
        this.maxContinueDay = maxContinueDay;
    }

    public Integer getCusCirDays() {
        return cusCirDays;
    }

    public void setCusCirDays(Integer cusCirDays) {
        this.cusCirDays = cusCirDays;
    }

    public Integer getRedCount() {
        return redCount;
    }

    public void setRedCount(Integer redCount) {
        this.redCount = redCount;
    }

    public Integer getRedCountTomorrow() {
        return redCountTomorrow;
    }

    public void setRedCountTomorrow(Integer redCountTomorrow) {
        this.redCountTomorrow = redCountTomorrow;
    }

    public Integer getPrizeChance() {
        return prizeChance;
    }

    public void setPrizeChance(Integer prizeChance) {
        this.prizeChance = prizeChance;
    }

    public Integer getPrizeChanceTomorrow() {
        return prizeChanceTomorrow;
    }

    public void setPrizeChanceTomorrow(Integer prizeChanceTomorrow) {
        this.prizeChanceTomorrow = prizeChanceTomorrow;
    }

    public List<HappyClearSignDTO> getSignList() {
        return signList;
    }

    public void setSignList(List<HappyClearSignDTO> signList) {
        this.signList = signList;
    }
}
