package cn.com.duiba.tuia.ecb.center.mix.dto.financial;

import java.io.Serializable;

/**
 * [工具类赚钱页]财务模型周期Dto
 *
 * @author zhangbaiqiang
 * @date 2020/3/30
 */
public class MixFinancialStageDto implements Serializable {
    private static final long serialVersionUID = -6039597994814494477L;

    /**
     * 第几周期
     */
    private Integer stage;

    /**
     * 天数
     */
    private Integer duration;

    /**
     * 现金上限
     */
    private Integer cashLimit;

    /**
     * 金币兑换汇率（1元能兑换的金币数）
     */
    private Integer coinExchangeRate;

    /**
     * 折损百分比 [0, 100]
     */
    private Integer discountRate;

    /**
     * 每日金币，计算方式：周期现金上限(cashLimit - 上一个周期的cashLimit) * 金币兑换汇率
     */
    private Integer dayIncomeLimit;

    public Integer getStage() {
        return stage;
    }

    public void setStage(Integer stage) {
        this.stage = stage;
    }

    public Integer getDuration() {
        return duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Integer getCashLimit() {
        return cashLimit;
    }

    public void setCashLimit(Integer cashLimit) {
        this.cashLimit = cashLimit;
    }

    public Integer getCoinExchangeRate() {
        return coinExchangeRate;
    }

    public void setCoinExchangeRate(Integer coinExchangeRate) {
        this.coinExchangeRate = coinExchangeRate;
    }

    public Integer getDiscountRate() {
        return discountRate;
    }

    public void setDiscountRate(Integer discountRate) {
        this.discountRate = discountRate;
    }

    public Integer getDayIncomeLimit() {
        return dayIncomeLimit;
    }

    public void setDayIncomeLimit(Integer dayIncomeLimit) {
        this.dayIncomeLimit = dayIncomeLimit;
    }
}
