package cn.com.duiba.tuia.ecb.center.video.enums;

/**
 * 激励视频来源
 * Created by xuefeng on 2019/6/10.
 */
public enum VideoSource {

    LOCAL(0, "本地视频"),
    TUIA(1, "推啊视频"),
    ;

    private Integer type;

    private String desc;

    VideoSource(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static VideoSource of(Integer type) {
        for (VideoSource videoSource : VideoSource.values()) {
            if(videoSource.getType().equals(type)) {
                return videoSource;
            }
        }
        return null;
    }
}
