package cn.com.duiba.tuia.ecb.center.mix.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.mix.dto.MixAppDTO;
import cn.com.duiba.tuia.ecb.center.mix.dto.MixAppSlotDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteMixAppService {

    List<MixAppDTO> selectAllMixApp();

    /**
     * 获取媒体分成配置信息
     *
     * @param appId
     * @return
     */
    MixAppDTO getMediaConfig(Long appId);

    /**
     * 更新媒体分成配置信息
     *
     * @param mixAppDTO 媒体配置
     * @return 是否配置成功
     */
    Boolean updateMediaConfig(MixAppDTO mixAppDTO);

    /**
     * 更新回流广告位
     *
     * @param appSlot 广告位信息
     */
    Boolean updateAppSlot(MixAppSlotDto appSlot);
}
