package cn.com.duiba.tuia.ecb.center.mix.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.mix.req.MixUserReq;

import java.time.LocalTime;
import java.util.Date;

@AdvancedFeignClient
public interface RemoteResetForTestService {

    Boolean resetForExchange(MixUserReq mixUserReq);

    void appIncomeTask();

    /**
     * 给指定用户设定日期用于测试(线上慎用)
     * 存到 Redis, 当日生效
     *
     * @param userId 用户id
     * @param dateStr 修改的日期(yyyy-MM-dd HH:mm:ss)
     * @return 修改后的日期
     */
    Date setDateForTest(Long userId, String dateStr);

    /**
     * 获取日期，特定用户可以获取指定日期用于测试
     *
     * @param userId 用户id
     * @return 日期
     */
    Date getDate(Long userId);

    /**
     * 指定兑换时间(线上慎用)
     *
     * @param timeStr hh-MM
     * @return 成功／失败
     */
    Boolean setExchangeTimeForTest(String timeStr);
}
