package cn.com.duiba.tuia.ecb.center.happy.dto;

import com.google.common.collect.Lists;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description: 苏宁消消乐-首页基础信息
 * @Author: fxr
 * @Date: 2019/8/24
 */
public class HappyClearHomeInfoDto implements Serializable {
    private static final long serialVersionUID = -4106087545824355385L;


    public static HappyClearHomeInfoDto init() {
        HappyClearHomeInfoDto homeInfoDto = new HappyClearHomeInfoDto();
        homeInfoDto.setGetAllTreasureBox(false);
        homeInfoDto.setCanReceiveTreasureBoxNum(0L);
        homeInfoDto.setTotalStars(0);
        homeInfoDto.setLevels(new ArrayList<>());
        homeInfoDto.setRemainProp(new ArrayList<>());
        homeInfoDto.setNextRangeStarsNum(0);
        homeInfoDto.setRemainEnargy(5);
        homeInfoDto.setWealth(0);
        homeInfoDto.setAskForEnergy(0L);
        homeInfoDto.setRedBombSwitchTime(0L);
        homeInfoDto.setRefectionCountdown(0L);
        return homeInfoDto;
    }


    /**
     * 财富值
     */
    private Integer wealth;

    /**
     * 总星星数
     */
    private Integer totalStars;

    /**
     * 用户关卡信息
     */
    private List<PersonalLevelInfoDto> levels = Lists.newArrayList();

    /**
     * 剩余道具
     */
    private List<PropDto> remainProp = Lists.newArrayList();

    /**
     * 剩余体力
     */
    private Integer remainEnargy;

    /**
     * 当日通过分享获取体力次数
     */
    private Long askForEnergy;

    /**
     * 当前可领取宝箱数量
     */
    private Long canReceiveTreasureBoxNum;

    /**
     * 用户下一个待领取宝箱需要累积星星数
     */
    private Integer nextRangeStarsNum;

    /**
     * 用户是否已领取所有的宝箱
     */
    private Boolean isGetAllTreasureBox;

    /**
     * 下一次恢复体力倒计时（秒）
     */
    private Long refectionCountdown;


    private Long redBombSwitchTime;

    public Integer getWealth() {
        return wealth;
    }

    public void setWealth(Integer wealth) {
        this.wealth = wealth;
    }

    public Integer getTotalStars() {
        return totalStars;
    }

    public void setTotalStars(Integer totalStars) {
        this.totalStars = totalStars;
    }

    public List<PersonalLevelInfoDto> getLevels() {
        return levels;
    }

    public void setLevels(List<PersonalLevelInfoDto> levels) {
        this.levels = levels;
    }

    public List<PropDto> getRemainProp() {
        return remainProp;
    }

    public void setRemainProp(List<PropDto> remainProp) {
        this.remainProp = remainProp;
    }

    public Integer getRemainEnargy() {
        return remainEnargy;
    }

    public void setRemainEnargy(Integer remainEnargy) {
        this.remainEnargy = remainEnargy;
    }

    public Long getAskForEnergy() {
        return askForEnergy;
    }

    public void setAskForEnergy(Long askForEnergy) {
        this.askForEnergy = askForEnergy;
    }

    public Long getCanReceiveTreasureBoxNum() {
        return canReceiveTreasureBoxNum;
    }

    public void setCanReceiveTreasureBoxNum(Long canReceiveTreasureBoxNum) {
        this.canReceiveTreasureBoxNum = canReceiveTreasureBoxNum;
    }

    public Integer getNextRangeStarsNum() {
        return nextRangeStarsNum;
    }

    public void setNextRangeStarsNum(Integer nextRangeStarsNum) {
        this.nextRangeStarsNum = nextRangeStarsNum;
    }

    public Boolean getGetAllTreasureBox() {
        return isGetAllTreasureBox;
    }

    public void setGetAllTreasureBox(Boolean getAllTreasureBox) {
        isGetAllTreasureBox = getAllTreasureBox;
    }

    public Long getRefectionCountdown() {
        return refectionCountdown;
    }

    public void setRefectionCountdown(Long refectionCountdown) {
        this.refectionCountdown = refectionCountdown;
    }

    public Long getRedBombSwitchTime() {
        return redBombSwitchTime;
    }

    public void setRedBombSwitchTime(Long redBombSwitchTime) {
        this.redBombSwitchTime = redBombSwitchTime;
    }
}
