package cn.com.duiba.tuia.ecb.center.mix.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.mix.dto.MixDto;
import cn.com.duiba.tuia.ecb.center.mix.req.MixPrizeReq;
import cn.com.duiba.tuia.ecb.center.mix.req.MixRewardReq;
import cn.com.duiba.tuia.ecb.center.mix.req.MixUserReq;

/**
 * [工具类赚钱页]主服务接口
 *
 * @author zhangbaiqiang
 * @date 2020/1/13
 */
@AdvancedFeignClient
public interface RemoteMixService {

    /**
     * 页面初始化
     */
    MixDto initialize(MixUserReq req) throws BizException;

    /**
     * 新手引导奖励
     */
    MixDto receiveNoviceRewards(MixUserReq req) throws BizException;

    /**
     * 查询参与奖励（主功能/任务）
     */
    MixDto queryParticipatePrize(MixPrizeReq req) throws BizException;

    /**
     * 第三方奖励回调
     */
    void rewardCallback(MixRewardReq req) throws BizException;

    /**
     * 更新新手引导步骤
     * @param req req
     * @return Boolean
     * @throws BizException
     */
    Boolean updateGuideStep(MixUserReq req) throws BizException;
}
