package cn.com.duiba.tuia.ecb.center.mix.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.mix.dto.MixCallbackLimitConfigDto;
import cn.com.duiba.tuia.ecb.center.mix.dto.MixConfigInSlotDto;
import cn.com.duiba.tuia.ecb.center.mix.dto.MixConfigResourceDto;
import cn.com.duiba.tuia.ecb.center.mix.dto.MixConfigTemplateDTO;
import cn.com.duiba.tuia.ecb.center.mix.dto.MixNewsRegionDto;
import cn.com.duiba.tuia.ecb.center.mix.dto.video.MixAdvertConfigDto;
import cn.com.duiba.tuia.ecb.center.mix.dto.video.MixRewardVideoConfigDto;
import cn.com.duiba.tuia.ecb.center.mix.req.MixNewsReq;
import com.alibaba.fastjson.JSONObject;

import java.util.List;

/**
 * [工具类赚钱页]配置接口
 *
 * @author zhangbaiqiang
 * @date 2020/1/20
 */
@AdvancedFeignClient
public interface RemoteMixConfigService {

    /**
     * 获取媒体的配置模板
     */
    MixConfigTemplateDTO getConfigTemplateByAppId(Long appId);

    /**
     * 获取活动的配置模板
     */
    MixConfigTemplateDTO getConfigTemplateByActivityId(Long activityId);

    /**
     * 获取配置模板
     */
    MixConfigTemplateDTO getConfigTemplate(Long configTemplateId);

    /**
     * 更新媒体配置
     *
     * @param appId 媒体id
     * @param configTemplate 配置模板
     */
    void updateAppConfig(Long appId, MixConfigTemplateDTO configTemplate) throws BizException;

    /**
     * 更新活动配置
     *
     * @param activityId 活动id
     * @param configTemplate 配置模板
     */
    void updateActivityConfig(Long activityId, MixConfigTemplateDTO configTemplate) throws BizException;

    /**
     * 查询激励视频投放规则配置
     *
     * @param activityId 活动id
     * @return 激励视频投放规则配置
     */
    MixRewardVideoConfigDto getRewardVideoConfig(Long activityId);

    /**
     * 更新激励视频投放规则配置
     *
     * @param config 配置
     * @return 活动id
     */
    void updateRewardVideoConfig(Long activityId, MixRewardVideoConfigDto config);

    /**
     * 查询回调风控规则配置
     *
     * @return 回调风控规则配置
     */
    MixCallbackLimitConfigDto getCallbackLimitDefaultConfig();

    /**
     * 更新回调风控规则配置
     *
     * @param config 回调风控规则配置
     */
    void updateCallbackLimitDefaultConfig(MixCallbackLimitConfigDto config);

    /**
     * 更新活动维度回调风控规则配置
     *
     * @param config 回调风控规则配置
     */
    void updateActivityCallbackConfig(MixCallbackLimitConfigDto config, Long activityId);

    /**
     * 清除媒体配置缓存，立即生效
     */
    void clearAppConfigCache(Long appId);

    /**
     * 清除活动配置缓存，立即生效
     */
    void clearActivityConfigCache(Long activityId);

    /*
    获取广告配置
     */
    MixAdvertConfigDto getAdvertConfig(Long activityId, Integer businessType);

    /*
    添加广告配置
     */
    Boolean addAdvertConfig(MixAdvertConfigDto configDto);

    /*
    更新广告配置
     */
    Boolean updateAdvertConfig(MixAdvertConfigDto configDto);

    /**
     * 批量更新广告配置
     * @param configList
     * @return
     */
    Boolean updateAdvertConfigList(List<MixAdvertConfigDto> configList, Long activityId);

    /**
     * 保存广告配置
     * @param configList
     * @param activityId
     * @return
     */
    Boolean  saveAdvertConfigList(List<MixAdvertConfigDto> configList, Long activityId);

    /**
     * 保存广告配置
     */
    Boolean saveAdvertConfig(MixAdvertConfigDto configDto);

    /**
     * 校验赚钱页配置
     */
    JSONObject verifyConfig(Long appId, Long activityId);

    /**
     * 初始化之后7天的媒体和广告位日收益表
     */
    void initAppAndSlotDayIncome();

    /**
     * 将缓存中的媒体广告位日收益数据持久化到数据库
     */
    void persistDayIncomeJob(String date);

    List<MixNewsRegionDto> getNewsAdvertConfig(MixNewsReq req);

    /**
     * 更新广告配置
     */
    Boolean updateNewsAdvertConfig(Long activityId, Integer businessType, String config);

    /**
     * 获取配置信息
     * @param bizType 1、广告位维度 2、活动维度
     * @param bizId id
     * @return 配置信息
     */
    MixConfigResourceDto getMixConfigResource(Integer bizType, Long bizId) throws BizException;

    /**
     * 保存配置信息
     * @param config 配置信息
     * @return 是否成功
     */
    Boolean saveMixConfigResource(MixConfigResourceDto config) throws BizException;



    /**
     * 保存广告位配置
     * @param config 配置
     * @return 是否成功
     */
    Boolean saveSlotConfig(MixConfigInSlotDto config) throws BizException;

    /**
     * 获取打开激励视频活动开关的广告位ID
     * @return
     */
    List<Long> getOpenEncourageVideoSwitchSolt();
}
