package cn.com.duiba.tuia.ecb.center.happy.enums;


public enum HappyClearAwardBizTypeEnum {
    FIRST_CROSS_AWARD(1, "首闯奖励"),
    TREASURE_BOX_AWARD(2, "宝箱奖励"),
    SIGN_AWARD(3, "签到奖励"),
    INVITE_AWARD(4, "邀请有礼奖励"),
    BIG_WHEEL_AWARD(5, "大转盘奖励"),
    SCRATCH_CARD_AWARD(6, "刮刮卡奖励"),
    RETURN_AWARD(7, "回归奖励"),
    VCOIN_EXCHANGE(8, "金币兑换"),
    RED_RAIN(9, "红包雨"),
    RED_BOMB(10, "红包炸弹"),
    TASK_SYSTEM(11, "任务体系"),
    CLOUD_DRILL_EXCHANGE(12, "云钻兑换"),


    /**
     * 推啊定制消消乐-通过观看激励视频可获取额外奖励的业务场景
     */
    DOUBLE_AWARD_SIGN(21, "签到双倍奖励"),
    DOUBLE_AWARD_TREASURE_BOX(22, "开星星宝箱双倍奖励"),
    FREE_PROP_BEFORE_PASS(23, "开局前免费道具获取"),
    FREE_PROP_PASSING(24, "游戏中免费道具获取"),
    DOUBLE_AWARD_PASS_SUCCESS(25, "闯关成功双倍奖励"),
    EXTRA_STEPS_PASS_FAIL(26, "闯关失败额外加步数"),
    MAP_ICON_AWARD(27, "地图页Icon奖励");

    Integer code;
    String desc;

    HappyClearAwardBizTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static HappyClearAwardBizTypeEnum valueOfCode(Integer code) {
        for (HappyClearAwardBizTypeEnum obj : HappyClearAwardBizTypeEnum.values()) {
            if (java.util.Objects.equals(obj.code, code)) {
                return obj;
            }
        }
        return null;
    }

    public static HappyClearAwardBizTypeEnum valueOfDesc(String desc) {
        for (HappyClearAwardBizTypeEnum obj : HappyClearAwardBizTypeEnum.values()) {
            if (java.util.Objects.equals(obj.desc, desc)) {
                return obj;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
