package cn.com.duiba.tuia.ecb.center.video.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * 加水类型
 * Created by xuefeng on 2019/5/14.
 */
public enum WaterAddType {

    BOX(100,"宝箱获取"),

    DAY(101,"每日奖励"),

    TASK_VIDOE(1,"领水任务-激励视频"),

    TASK_NOVEL(2,"领水任务-小说"),

    TASK_HOT_WORD(3,"领水任务-热词"),

    ;
    private static final Map<Integer, WaterAddType> CACHE = Maps.uniqueIndex(Arrays.asList(WaterAddType
            .values()), WaterAddType::getCode);

    private Integer code;
    private String desc;

    WaterAddType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    public boolean same(Integer other) {
        if (other == null) {
            return false;
        }
        return code.equals(other);
    }

    public static WaterAddType of(Integer aCode) {
        return CACHE.get(aCode);
    }
}
