package cn.com.duiba.tuia.ecb.center.mix.dto.video.shcc;

import java.io.Serializable;

/**
 * 上海呈驰视频请求
 * Created by xuefeng on 2020/1/20.
 */
public class MixShccVideoReq implements Serializable {
    private static final long serialVersionUID = 1418791101210058438L;

    private String requestId;

    private App app;

    private Slot slot;

    private Device device;

    private Network network;

    /**
     * App信息
     */
    public static class App implements Serializable {

        private static final long serialVersionUID = -4493189066393317297L;

        //应用ID
        private String appId;

        //应用包名
        private String appPackage;

        //应用版本
        private String appVersion;

        //应用名称
        private String appName;

        public String getAppId() {
            return appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getAppPackage() {
            return appPackage;
        }

        public void setAppPackage(String appPackage) {
            this.appPackage = appPackage;
        }

        public String getAppVersion() {
            return appVersion;
        }

        public void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        public String getAppName() {
            return appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }
    }

    /**
     * Slot信息
     */
    public static class Slot implements Serializable {

        private static final long serialVersionUID = -1276098320660582704L;

        //广告位 ID
        private String slotId;

        //广告位宽度
        private int slotwidth;

        //广告位高度
        private int slotheight;

        //广告类型 1- 横幅 2- 开屏 3- 插屏 4- 信息流 5- 激励视频 6- 文字链
        private int adtype;

        public String getSlotId() {
            return slotId;
        }

        public void setSlotId(String slotId) {
            this.slotId = slotId;
        }

        public int getSlotwidth() {
            return slotwidth;
        }

        public void setSlotwidth(int slotwidth) {
            this.slotwidth = slotwidth;
        }

        public int getSlotheight() {
            return slotheight;
        }

        public void setSlotheight(int slotheight) {
            this.slotheight = slotheight;
        }

        public int getAdtype() {
            return adtype;
        }

        public void setAdtype(int adtype) {
            this.adtype = adtype;
        }
    }

    /**
     * Device信息
     */
    public static class Device implements Serializable {

        private static final long serialVersionUID = -7457184687102463555L;

        //IOS 设备唯一标识码
        private String idfa;

        //安卓设备唯一标识码
        private String imei;

        //MAC 地址
        private String mac;

        //安卓设备 ID
        private String androidId;

        //操作系统类型
        private int osType;

        //操作系统版本
        private String osVersion;

        //设备类型 1- 手机 2- 平板
        private int deviceType;

        //设备厂商
        private String vendor;

        //手机品牌
        private String brand;

        //设备型号
        private String model;

        //设备屏幕宽度
        private int screenWidth;

        //设备屏幕高度
        private int screenHeight;

        //User-agent
        private String ua;

        //屏幕大小(单位 ppi, 每英寸所有的像素)
        private int ppi;

        //横竖屏 0- 未知 1- 竖屏 2- 横屏
        private int screenOrientation;

        //imsi
        private String imsi;

        public String getIdfa() {
            return idfa;
        }

        public void setIdfa(String idfa) {
            this.idfa = idfa;
        }

        public String getImei() {
            return imei;
        }

        public void setImei(String imei) {
            this.imei = imei;
        }

        public String getAndroidId() {
            return androidId;
        }

        public void setAndroidId(String androidId) {
            this.androidId = androidId;
        }

        public int getOsType() {
            return osType;
        }

        public void setOsType(int osType) {
            this.osType = osType;
        }

        public String getOsVersion() {
            return osVersion;
        }

        public void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        public int getDeviceType() {
            return deviceType;
        }

        public void setDeviceType(int deviceType) {
            this.deviceType = deviceType;
        }

        public String getVendor() {
            return vendor;
        }

        public void setVendor(String vendor) {
            this.vendor = vendor;
        }

        public String getBrand() {
            return brand;
        }

        public void setBrand(String brand) {
            this.brand = brand;
        }

        public String getModel() {
            return model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public int getScreenWidth() {
            return screenWidth;
        }

        public void setScreenWidth(int screenWidth) {
            this.screenWidth = screenWidth;
        }

        public int getScreenHeight() {
            return screenHeight;
        }

        public void setScreenHeight(int screenHeight) {
            this.screenHeight = screenHeight;
        }

        public String getUa() {
            return ua;
        }

        public void setUa(String ua) {
            this.ua = ua;
        }

        public int getPpi() {
            return ppi;
        }

        public void setPpi(int ppi) {
            this.ppi = ppi;
        }

        public int getScreenOrientation() {
            return screenOrientation;
        }

        public void setScreenOrientation(int screenOrientation) {
            this.screenOrientation = screenOrientation;
        }

        public String getImsi() {
            return imsi;
        }

        public void setImsi(String imsi) {
            this.imsi = imsi;
        }

        public String getMac() {
            return mac;
        }

        public void setMac(String mac) {
            this.mac = mac;
        }
    }

    /**
     * Network信息
     */
    public static class Network implements Serializable {

        private static final long serialVersionUID = 2621656243814777523L;

        //IPv4 地址
        private String ip;

        //0- 未知 1- 中国移动 2- 中国电信 3- 中国联通 99-其他运营商
        private String operatorType;

        //0- 未知网络 2- 2G 3- 3G 4- 4G 5- 5G 100-WIFI 101—ETHERNET 999--NEW_TYPE
        private int connectType;

        //纬度(无法获取填 0)
        private double lat;

        //经度(无法获取填 0)
        private double lon;

        //基站 ID
        private String cellular_id;

        public String getIp() {
            return ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public int getConnectType() {
            return connectType;
        }

        public void setConnectType(int connectType) {
            this.connectType = connectType;
        }

        public double getLat() {
            return lat;
        }

        public void setLat(double lat) {
            this.lat = lat;
        }

        public double getLon() {
            return lon;
        }

        public void setLon(double lon) {
            this.lon = lon;
        }

        public String getCellular_id() {
            return cellular_id;
        }

        public void setCellular_id(String cellular_id) {
            this.cellular_id = cellular_id;
        }

        public String getOperatorType() {
            return operatorType;
        }

        public void setOperatorType(String operatorType) {
            this.operatorType = operatorType;
        }
    }

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public App getApp() {
        return app;
    }

    public void setApp(App app) {
        this.app = app;
    }

    public Slot getSlot() {
        return slot;
    }

    public void setSlot(Slot slot) {
        this.slot = slot;
    }

    public Device getDevice() {
        return device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public Network getNetwork() {
        return network;
    }

    public void setNetwork(Network network) {
        this.network = network;
    }
}
