package cn.com.duiba.tuia.ecb.center.mix.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.common.BasePair;
import cn.com.duiba.tuia.ecb.center.mix.dto.*;

import java.util.List;

@AdvancedFeignClient
public interface RemoteMixAppService {

    List<MixAppDTO> selectAllMixApp();

    /**
     * 获取媒体分成配置信息
     *
     * @param appId
     * @return
     */
    MixAppDTO getMediaConfig(Long appId);

    /**
     * 更新媒体分成配置信息
     *
     * @param mixAppDTO 媒体配置
     * @return 是否配置成功
     */
    Boolean updateMediaConfig(MixAppDTO mixAppDTO);

    /**
     * 更新媒体的广告位分成配置信息
     *
     * @param rateList 分成比例列表
     */
    void updateSlotExchangeRate(List<MixExchangeRateConfigDto> rateList) throws BizException;

    /**
     * 更新回流广告位
     *
     * @param appSlot 广告位信息
     */
    Boolean updateAppSlot(MixAppSlotDto appSlot);

    /**
     * 查询媒体昨天的分成比例
     */
    MixExchangeRateConfigDto queryAppExchangeRate(Long appId, String date);

    /**
     * 查询媒体的广告位昨天的分成比例
     */
    List<MixExchangeRateConfigDto> querySlotExchangeRate(Long appId, String date);

    /**
     * 添加回流广告位（返回失败原因）
     * @param appSlot
     * @return
     */
    BasePair<Boolean, String> addAppSlot(MixAppSlotDto appSlot);

    /**
     * 更新回流广告位（返回失败原因）
     * @param appSlot
     * @return
     */
    BasePair<Boolean, String> onlyUpdateAppSlot(MixAppSlotDto appSlot);

    /**
     * 删除
     * @param id
     * @return
     */
    Boolean deleteById(Long id);

    /**
     * 分页查询回流广告位
     * @param mixAppSlotQueryDto
     * @return
     */
    PageDTO<MixAppSlotDto> appSlotPage(MixAppSlotQueryDto mixAppSlotQueryDto);
}
