package cn.com.duiba.tuia.ecb.center.fl.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.common.BaseUserReq;
import cn.com.duiba.tuia.ecb.center.fl.dto.FiveLuckyDto;
import cn.com.duiba.tuia.ecb.center.fl.dto.FiveLuckyMultiDto;
import cn.com.duiba.tuia.ecb.center.fl.dto.FiveLuckySingleDto;
import cn.com.duiba.tuia.ecb.center.fl.req.FiveLuckyDoJoinReq;
import cn.com.duiba.tuia.ecb.center.fl.req.FiveLuckyInitFetchReq;

@AdvancedFeignClient
public interface RemoteFiveLuckyService {

    /**
     * 初始化
     * @param userBizReq
     * @return
     */
    FiveLuckyDto initialize(BaseUserReq userBizReq) throws BizException;

    /**
     * 初始领福卡
     * @param userBizReq
     */
    FiveLuckySingleDto initFetch(FiveLuckyInitFetchReq userBizReq) throws BizException;


    /**
     * 默认的参与领福卡
     * @param userBizReq
     * @return
     * @throws BizException
     */
    FiveLuckySingleDto doJoin(BaseUserReq userBizReq) throws BizException;

    /**
     * 参与领福卡 扩展版
     * @param userBizReq
     * @return
     */
    FiveLuckySingleDto doJoinV2(FiveLuckyDoJoinReq userBizReq) throws BizException;

    /**
     * 开宝箱
     * @param userBizReq
     * @return
     */
    FiveLuckySingleDto openBox(BaseUserReq userBizReq) throws BizException;

    /**
     * 查询奖励
     * @param userBizReq
     * @return
     */
    FiveLuckyMultiDto queryPrize(BaseUserReq userBizReq) throws BizException;
}
