package cn.com.duiba.tuia.ecb.center.draw.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.draw.dto.red.RedDrawDTO;
import cn.com.duiba.tuia.ecb.center.draw.dto.red.RedDrawLuckResultDTO;
import cn.com.duiba.tuia.ecb.center.mix.req.MixUserReq;

/**
 * @ClassName RemoteRedDrawService
 * @Description 红包大转盘service
 * @Author Zaizai
 * @Date 2020/12/22 9:50 上午
 **/
@AdvancedFeignClient
public interface RemoteRedDrawService {

    /**
     * 初始化红包抽奖活动
     * @param mixUserReq
     * @return
     */
    RedDrawDTO initialize(MixUserReq mixUserReq) throws BizException;

    /**
     * 参与抽奖活动
     * @param mixUserReq
     * @return
     * @throws BizException
     */
    RedDrawLuckResultDTO doJoin(MixUserReq mixUserReq) throws BizException;

}
