package cn.com.duiba.tuia.ecb.center.mix.enums;

import java.util.Objects;

/**
 * 寻宝活动格子类型
 * Created by zxw on 2020-09-27.
 */
public enum SeekCellType {

    BLANK(0, "空白格"),
    GIFT(1, "奖品格"),
    BOMB(2, "炸弹格");

    private Integer type;
    private String desc;

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    SeekCellType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static SeekCellType getType(Integer type) {
        for (SeekCellType cellType : SeekCellType.values()) {
            if (Objects.equals(cellType.getType(), type)) {
                return cellType;
            }
        }
        return null;
    }


}
