package cn.com.duiba.tuia.ecb.center.mix.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.mix.dto.lottery.MixLotteryAdDto;
import cn.com.duiba.tuia.ecb.center.mix.dto.lottery.MixLotteryCornerDto;
import cn.com.duiba.tuia.ecb.center.mix.dto.lottery.MixLotteryDetailDto;
import cn.com.duiba.tuia.ecb.center.mix.dto.PageDTO;
import cn.com.duiba.tuia.ecb.center.mix.req.MixUserPageReq;
import cn.com.duiba.tuia.ecb.center.mix.req.MixUserReq;

/**
 * [工具类赚钱页]彩票
 * Created by xuefeng on 2020/4/9.
 */
@AdvancedFeignClient
public interface RemoteMixLotteryService {

    /**
     * 获取彩票详情
     *
     * @return
     */
    MixLotteryDetailDto detail(MixUserReq req) throws BizException;

    /**
     * 获取彩票详情
     *
     * @return
     */
    MixLotteryAdDto captureTicket(MixUserReq req) throws BizException;

    /**
     * 用户彩票中奖纪录
     *
     * @param req
     * @return
     */
    PageDTO<MixLotteryDetailDto> records(MixUserPageReq req) throws BizException;

    /**
     * 角标状态
     *
     * @param req
     * @return
     * @throws BizException
     */
    MixLotteryCornerDto corner(MixUserReq req) throws BizException;
}
