package cn.com.duiba.tuia.ecb.center.common.enums;

import com.google.common.collect.Lists;
import io.swagger.models.auth.In;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author huangruodan
 * @version 创建时间：2020/3/16 4:51 下午
 */
public enum DeviceType {
    MOBILE(1, "PHONE"),
    PAD(2, "TABLET");

    private Integer type;

    private String desc;

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    DeviceType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static DeviceType getByType(Integer type) {
        List<DeviceType> deviceList = Lists.newArrayList(DeviceType.values())
                .stream()
                .filter(input -> input.getType().equals(type))
                .collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(deviceList)) {
            return deviceList.get(0);
        }
        return MOBILE;
    }

}
