package cn.com.duiba.tuia.ecb.center.draw.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.draw.dto.*;
import cn.com.duiba.tuia.ecb.center.mix.req.MixUserReq;

import java.util.List;

/**
 * @ClassName RemoteDrawService
 * @Description
 * @Author Zaizai
 * @Date 2020/9/11 5:20 下午
 **/
@AdvancedFeignClient
public interface RemoteDrawService {

    /**
     * 初始化抽奖活动
     * @param mixUserReq
     * @return
     * @throws BizException
     */
    DrawDTO initialize(MixUserReq mixUserReq) throws BizException;

    /**
     * 参与抽奖
     * @param mixUserReq
     * @return
     * @throws BizException
     */
    DrawLuckResultDTO doJoin(MixUserReq mixUserReq) throws BizException;

    /**
     * 获取碎片中将记录
     * @param mixUserReq
     * @return
     * @throws BizException
     */
    List<UserFragmentDTO> getUserFragment(MixUserReq mixUserReq) throws BizException;

    /**
     * 开宝箱
     * @param mixUserReq
     * @param boxPosition
     * @return
     */
    DrawBoxResultDTO pickBox(MixUserReq mixUserReq, Integer boxPosition) throws BizException;

    /**
     * 获取用户活动信息
     * @param mixUserReq
     * @return
     * @throws BizException
     */
    DrawUserResultDTO queryDrawUser(MixUserReq mixUserReq) throws BizException;
}
