package cn.com.duiba.tuia.ecb.center.cal.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 【日历签到】配置
 * Created by xuefeng on 2020/4/20.
 */
public class CalSignConfigDto implements Serializable {

    private static final long serialVersionUID = 5510186664026728094L;

    private List<RewardConfig> rConfigs;

    private List<ProgressConfig> pConfigs;

    public List<RewardConfig> getRConfigs() {
        return rConfigs;
    }

    public void setRConfigs(List<RewardConfig> rConfigs) {
        this.rConfigs = rConfigs;
    }

    public List<ProgressConfig> getPConfigs() {
        return pConfigs;
    }

    public void setPConfigs(List<ProgressConfig> pConfigs) {
        this.pConfigs = pConfigs;
    }

    /**
     * 签到奖励
     */
    public static class RewardConfig implements Serializable {

        private static final long serialVersionUID = 3765355810399637017L;

        //周期中天数
        private int day;
        //当天参与次数
        private int times;
        private Long prizeId;
        private Integer score;

        public int getDay() {
            return day;
        }

        public void setDay(int day) {
            this.day = day;
        }

        public int getTimes() {
            return times;
        }

        public void setTimes(int times) {
            this.times = times;
        }

        public Long getPrizeId() {
            return prizeId;
        }

        public void setPrizeId(Long prizeId) {
            this.prizeId = prizeId;
        }

        public Integer getScore() {
            return score;
        }

        public void setScore(Integer score) {
            this.score = score;
        }
    }

    public static class ProgressConfig implements Serializable {

        private static final long serialVersionUID = 3950959283458459437L;

        //累计天数
        private int day;
        private Long prizeId;
        private Integer score;

        public int getDay() {
            return day;
        }

        public void setDay(int day) {
            this.day = day;
        }

        public Long getPrizeId() {
            return prizeId;
        }

        public void setPrizeId(Long prizeId) {
            this.prizeId = prizeId;
        }

        public Integer getScore() {
            return score;
        }

        public void setScore(Integer score) {
            this.score = score;
        }
    }
}
