package cn.com.duiba.tuia.ecb.center.cal.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.cal.dto.CalSignDto;
import cn.com.duiba.tuia.ecb.center.cal.req.CalDoJoinReq;
import cn.com.duiba.tuia.ecb.center.cal.req.CalUserReq;

/**
 * [日历签到]
 * Created by xuefeng on 2020/4/20.
 */
@AdvancedFeignClient
public interface RemoteCalSignService {

    /**
     * 初始化
     *
     * @param req
     * @return
     */
    CalSignDto initialize(CalUserReq req) throws BizException;

    /**
     * 签到参与
     *
     * @param req
     * @return
     */
    Boolean doJoin(CalDoJoinReq req) throws BizException;

    /**
     * 领取累计奖励
     *
     * @param req
     * @return
     */
    Boolean fetchReward(CalDoJoinReq req) throws BizException;
}
