package cn.com.duiba.tuia.ecb.center.happy.dto;

import com.google.common.collect.Lists;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description: 苏宁消消乐-首页基础信息
 * @Author: fxr
 * @Date: 2019/8/24
 */

@Getter
@Setter
public class HappyClearHomeInfoDto implements Serializable {
    private static final long serialVersionUID = -4106087545824355385L;


    private String nickName;


    /**
     * 财富值
     */
    private Integer wealth;

    /**
     * 总星星数
     */
    private Integer totalStars;

    /**
     * 用户关卡信息
     */
    private List<PersonalLevelInfoDto> levels = Lists.newArrayList();

    /**
     * 剩余道具
     */
    private List<PropDto> remainProp = Lists.newArrayList();


    /**
     * 星星宝箱
     */
    private List<HappyClearStarBoxRecordDTO> starBoxList = Lists.newArrayList();

    /**
     * 剩余体力
     */
    private Integer remainEnargy;

    /**
     * 当日通过分享获取体力次数
     */
    private Long askForEnergy;

    /**
     * 当前可领取宝箱数量
     */
    private Long canReceiveTreasureBoxNum;

    /**
     * 用户下一个待领取宝箱需要累积星星数
     */
    private Integer nextRangeStarsNum;

    /**
     * 用户是否已领取所有的宝箱
     */
    private Boolean isGetAllTreasureBox;

    /**
     * 下一次恢复体力倒计时（秒）
     */
    private Long refectionCountdown;


    private Long redBombSwitchTime;

    private Integer powerConsume;

    private String avatar;

    private Integer currentVideoTimes;

    private Integer totalVideoTimes;

    public static HappyClearHomeInfoDto init(Integer remainEnergy, String avatar, String nickName) {
        HappyClearHomeInfoDto homeInfoDto = new HappyClearHomeInfoDto();
        homeInfoDto.setTotalStars(0);
        homeInfoDto.setLevels(new ArrayList<>());
        homeInfoDto.setRemainProp(new ArrayList<>());
        homeInfoDto.setRemainEnargy(remainEnergy);
        homeInfoDto.setRedBombSwitchTime(0L);
        // homeInfoDto.setPowerConsume(powerConsume);
        homeInfoDto.setAvatar(avatar);
        homeInfoDto.setNickName(nickName);
        return homeInfoDto;
    }

    private List<HappyClearExchangeItem> shoppingItems;



}
