package cn.com.duiba.tuia.ecb.center.mix.dto.financial;

import java.io.Serializable;
import java.util.Map;

/**
 * [工具类赚钱页]财务模型Dto
 *
 * @author zhangbaiqiang
 * @date 2020/3/31
 */
public class MixFinancialModelDto implements Serializable {
    private static final long serialVersionUID = 3590389371468449798L;

    /**
     * 当前周期
     */
    private Integer stage;

    /**
     * 每日金币
     */
    private Integer dayIncome;

    /**
     * 固定金币
     */
    private Integer fixedAmount;

    /**
     * 折损百分比 [0, 100]
     */
    private Integer discountRate;

    /**
     * 随机金币
     */
    private Integer randomIncome;

    /**
     * 金币兑换汇率（1元能兑换的金币数）
     */
    private Integer coinExchangeRate;

    /**
     * 随机金币上限, 业务类型-金币上限映射
     */
    private Map<Integer, Integer> randomIncomeLimit;

    public Integer getStage() {
        return stage;
    }

    public void setStage(Integer stage) {
        this.stage = stage;
    }

    public Integer getDayIncome() {
        return dayIncome;
    }

    public void setDayIncome(Integer dayIncome) {
        this.dayIncome = dayIncome;
    }

    public Integer getFixedAmount() {
        return fixedAmount;
    }

    public void setFixedAmount(Integer fixedAmount) {
        this.fixedAmount = fixedAmount;
    }

    public Integer getDiscountRate() {
        return discountRate;
    }

    public void setDiscountRate(Integer discountRate) {
        this.discountRate = discountRate;
    }

    public Integer getRandomIncome() {
        return randomIncome;
    }

    public void setRandomIncome(Integer randomIncome) {
        this.randomIncome = randomIncome;
    }

    public Integer getCoinExchangeRate() {
        return coinExchangeRate;
    }

    public void setCoinExchangeRate(Integer coinExchangeRate) {
        this.coinExchangeRate = coinExchangeRate;
    }

    public Map<Integer, Integer> getRandomIncomeLimit() {
        return randomIncomeLimit;
    }

    public void setRandomIncomeLimit(Map<Integer, Integer> randomIncomeLimit) {
        this.randomIncomeLimit = randomIncomeLimit;
    }
}
