package cn.com.duiba.tuia.ecb.center.common.enums;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @ClassName DrawV2ComponentEnums
 * @Description
 * @Author Zaizai
 * @Date 2021/3/3 2:19 下午
 **/
public enum DrawV2ComponentEnum {

    MYSTICAL_GIFT("mysticalGift", ComponentTypeEnum.COMMON, ComponentInitSortEnum.SECOND_BATCH, "神秘礼包"),
    PRIZE_PROGRESS("prizeProgress", ComponentTypeEnum.COMMON, ComponentInitSortEnum.THIRD_BATCH, "奖励进度"),
    BOX("box", ComponentTypeEnum.COMMON, ComponentInitSortEnum.SECOND_BATCH, "天降礼包"),
    EXTRA_TIMES("extraTimes", ComponentTypeEnum.COMMON, ComponentInitSortEnum.THIRD_BATCH, "额外次数"),
    VIDEO_ANSWER("videoAnswer", ComponentTypeEnum.COMMON, ComponentInitSortEnum.SECOND_BATCH, "看视频答题"),
    XMLY_USER_JOIN_STATE("xmlyUserJoinState", ComponentTypeEnum.COMMON, null, "喜马拉雅用户参与状态"),
    PLAY_USER("playUser", ComponentTypeEnum.PLAY, ComponentInitSortEnum.FIRST_BATCH, "红包大转盘玩法用户"),
    ;

    DrawV2ComponentEnum(String componentId, ComponentTypeEnum componentType, ComponentInitSortEnum sortEnum, String desc) {
        this.componentId = componentId;
        this.componentType = componentType;
        this.sortEnum = sortEnum;
        this.desc = desc;
    }

    private String componentId;
    private ComponentTypeEnum componentType;
    private ComponentInitSortEnum sortEnum;
    private String desc;

    public String getComponentId() {
        return componentId;
    }

    public ComponentTypeEnum getComponentType() {
        return componentType;
    }

    public ComponentInitSortEnum getSortEnum() {
        return sortEnum;
    }

    public String getDesc() {
        return desc;
    }

    public static List<String> getAllComponentId() {
        return Arrays.stream(values())
                .map(DrawV2ComponentEnum::getComponentId)
                .collect(Collectors.toList());
    }

    public static String getPlayComponentId(List<String> componentIds) {
        for (DrawV2ComponentEnum value : values()) {
            if (value.componentType == ComponentTypeEnum.PLAY && componentIds.contains(value.getComponentId())) {
                return value.getComponentId();
            }
        }
        return null;
    }

    public static Map<ComponentInitSortEnum, List<String>> groupByComponentInitSortEnum(List<String> componentIds) {
        return Arrays.stream(values())
                .filter(value -> componentIds.contains(value.getComponentId()) && value.getSortEnum() != null)
                .collect(Collectors.groupingBy(DrawV2ComponentEnum::getSortEnum,
                        Collectors.mapping(DrawV2ComponentEnum::getComponentId, Collectors.toList())));
    }


}
