package cn.com.duiba.tuia.ecb.center.fl.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.common.BaseUserReq;
import cn.com.duiba.tuia.ecb.center.fl.dto.FiveLuckyDto;
import cn.com.duiba.tuia.ecb.center.fl.dto.FiveLuckyMultiDto;
import cn.com.duiba.tuia.ecb.center.fl.dto.FiveLuckySingleDto;
import cn.com.duiba.tuia.ecb.center.fl.req.FiveLuckyDoJoinReq;
import cn.com.duiba.tuia.ecb.center.fl.req.FiveLuckyInitFetchReq;

@AdvancedFeignClient
public interface RemoteFiveLuckyService {

    /**
     * 初始化
     * @param userBizReq
     * @return
     */
    FiveLuckyDto initialize(BaseUserReq userBizReq) throws BizException;

    /**
     * 初始领福卡
     * @param userBizReq
     */
    FiveLuckySingleDto initFetch(FiveLuckyInitFetchReq userBizReq) throws BizException;


    /**
     * 默认的参与领福卡
     * @param userBizReq
     * @return
     * @throws BizException
     */
    FiveLuckySingleDto doJoin(BaseUserReq userBizReq) throws BizException;

    /**
     * 参与领福卡 扩展版
     * @param userBizReq
     * @return
     */
    FiveLuckySingleDto doJoinV2(FiveLuckyDoJoinReq userBizReq) throws BizException;

    /**
     * 开宝箱
     * @param userBizReq
     * @return
     */
    FiveLuckySingleDto openBox(BaseUserReq userBizReq) throws BizException;

    /**
     * 查询奖励
     * @param userBizReq
     * @return
     */
    FiveLuckyMultiDto queryPrize(BaseUserReq userBizReq) throws BizException;

    /**
     * 获取漂流福
     * @param userBizReq
     * @return
     * @throws BizException
     */
    String drift(BaseUserReq userBizReq) throws BizException;

    /**
     * 赠送福卡
     * @param userBizReq
     * @param name
     * @return
     * @throws BizException
     */
    Boolean sentByName(BaseUserReq userBizReq, String name) throws BizException;

    /**
     * 设置用户CVR提交信息
     * @param baseUserReq
     * @return
     */
    Boolean setFormSentMark(BaseUserReq baseUserReq) throws BizException;

    /**
     * 查询用户CVR提交信息
     * @param baseUserReq
     * @return
     */
    Boolean checkFormSentMark(BaseUserReq baseUserReq) throws BizException;

    /**
     * 删除用户CVR提交信息
     * @param baseUserReq
     * @return
     */
    Boolean deleteFormSentMark(BaseUserReq baseUserReq) throws BizException;

}
