/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ecb.center.common.enums;

import cn.com.duiba.tuia.ecb.center.common.enums.ComponentInitSortEnum;
import cn.com.duiba.tuia.ecb.center.common.enums.ComponentTypeEnum;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum DrawV2ComponentEnum {
    MYSTICAL_GIFT("mysticalGift", ComponentTypeEnum.COMMON, ComponentInitSortEnum.SECOND_BATCH, "\u795e\u79d8\u793c\u5305"),
    PRIZE_PROGRESS("prizeProgress", ComponentTypeEnum.COMMON, ComponentInitSortEnum.THIRD_BATCH, "\u5956\u52b1\u8fdb\u5ea6"),
    BOX("box", ComponentTypeEnum.COMMON, ComponentInitSortEnum.SECOND_BATCH, "\u5929\u964d\u793c\u5305"),
    EXTRA_TIMES("extraTimes", ComponentTypeEnum.COMMON, ComponentInitSortEnum.THIRD_BATCH, "\u989d\u5916\u6b21\u6570"),
    VIDEO_ANSWER("videoAnswer", ComponentTypeEnum.COMMON, ComponentInitSortEnum.SECOND_BATCH, "\u770b\u89c6\u9891\u7b54\u9898"),
    XMLY_USER_JOIN_STATE("xmlyUserJoinState", ComponentTypeEnum.COMMON, null, "\u559c\u9a6c\u62c9\u96c5\u7528\u6237\u53c2\u4e0e\u72b6\u6001"),
    PLAY_USER("playUser", ComponentTypeEnum.PLAY, ComponentInitSortEnum.FIRST_BATCH, "\u7ea2\u5305\u5927\u8f6c\u76d8\u73a9\u6cd5\u7528\u6237");

    private String componentId;
    private ComponentTypeEnum componentType;
    private ComponentInitSortEnum sortEnum;
    private String desc;

    private DrawV2ComponentEnum(String componentId, ComponentTypeEnum componentType, ComponentInitSortEnum sortEnum, String desc) {
        this.componentId = componentId;
        this.componentType = componentType;
        this.sortEnum = sortEnum;
        this.desc = desc;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public ComponentTypeEnum getComponentType() {
        return this.componentType;
    }

    public ComponentInitSortEnum getSortEnum() {
        return this.sortEnum;
    }

    public String getDesc() {
        return this.desc;
    }

    public static List<String> getAllComponentId() {
        return Arrays.stream(DrawV2ComponentEnum.values()).map(DrawV2ComponentEnum::getComponentId).collect(Collectors.toList());
    }

    public static String getPlayComponentId(List<String> componentIds) {
        for (DrawV2ComponentEnum value : DrawV2ComponentEnum.values()) {
            if (value.componentType != ComponentTypeEnum.PLAY || !componentIds.contains(value.getComponentId())) continue;
            return value.getComponentId();
        }
        return null;
    }

    public static Map<ComponentInitSortEnum, List<String>> groupByComponentInitSortEnum(List<String> componentIds) {
        return Arrays.stream(DrawV2ComponentEnum.values()).filter(value -> componentIds.contains(value.getComponentId()) && value.getSortEnum() != null).collect(Collectors.groupingBy(DrawV2ComponentEnum::getSortEnum, Collectors.mapping(DrawV2ComponentEnum::getComponentId, Collectors.toList())));
    }
}

