package cn.com.duiba.tuia.ecb.center.fl.enums;

import cn.com.duiba.tuia.ecb.center.fl.dto.FiveLuckyCardDto;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Random;

public enum FiveLuckyType {
    HX("hx", "和谐福"),
    YS("ys", "友善福"),
    FQ("fq", "富强福"),
    AG("ag", "爱国福"),
    JY("jy", "敬业福"),
    ;

    private String name;
    private String desc;

    FiveLuckyType(String name, String desc) {
        this.name = name;
        this.desc = desc;
    }

    public String getName() {
        return name;
    }

    /**
     * 出一张随机福卡
     * @return
     */
    public static FiveLuckyType getRandom() {
        FiveLuckyType[] types = {HX, YS, FQ, JY};
        return types[new Random().nextInt(4)];
    }

    /**
     * 其他福出一张随机福卡
     * @param name
     * @return
     */
    public static FiveLuckyType getRandom(String name) {
        FiveLuckyType[] types = new FiveLuckyType[3];
        int i = 0;
        for (FiveLuckyType value : FiveLuckyType.values()) {
            if (value == FiveLuckyType.AG || value.getName().equals(name) || i > 2) {
                continue;
            }
            types[i++] = value;
        }
        return types[new Random().nextInt(3)];
    }

    /**
     * 福卡个数+1
     * @param fiveLucks
     * @param type
     * @return
     */
    public static void add(List<FiveLuckyCardDto> fiveLucks, FiveLuckyType type) {
        if (CollectionUtils.isEmpty(fiveLucks)) {
            return;
        }
        for (FiveLuckyCardDto fiveLuck : fiveLucks) {
            if (type.getName().equals(fiveLuck.getName())) {
                fiveLuck.add();
            }
        }
    }

    /**
     * 根据名字出一张固定福，没有则随机
     * @param name
     * @return
     */
    public static FiveLuckyType getFixed(String name) {
        FiveLuckyType[] types = {HX, YS, FQ, JY};
        for (FiveLuckyType type : types) {
            if (type.getName().equals(name)) {
                return type;
            }
        }
        return getRandom();
    }

    /**
     * 福卡个数-1
     * @param fiveLucks
     * @param type
     * @return
     */
    public static void reduce(List<FiveLuckyCardDto> fiveLucks, FiveLuckyType type) {
        if (CollectionUtils.isEmpty(fiveLucks) || type == null) {
            return ;
        }
        for (FiveLuckyCardDto fiveLuck : fiveLucks) {
            if (type.getName().equals(fiveLuck.getName())) {
                fiveLuck.reduce();
            }
        }
    }

    /**
     * 根据名称获取福气
     * @param name
     * @return
     */
    public static FiveLuckyType getFourLuckyByName(String name) {
        FiveLuckyType[] types = {HX, YS, FQ, JY};
        for (FiveLuckyType type : types) {
            if (type.getName().equals(name)) {
                return type;
            }
        }
        return null;
    }
}
