package cn.com.duiba.tuia.ecb.center.happy.enums;

import lombok.Getter;

/**
 * @author: zxw
 * @Date: 2021/5/14 2:38 下午
 * @Description: 宝箱类型
 */

@Getter
public enum BoxTypeEnum {
    //WING(1, "元宝"),
    ONE(1, "一星宝箱"),
    TWO(2, "二星宝箱"),
    THREE(3, "三星宝箱"),
    MYSTERY(4, "盲盒"),
    HEAVEN_GIFT(5, "天降礼包");


    BoxTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private Integer type;

    private String desc;

    public static BoxTypeEnum of(Integer type) {
        for (BoxTypeEnum propTypeEnum : BoxTypeEnum.values()) {
            if (propTypeEnum.getType().equals(type)) {
                return propTypeEnum;
            }
        }
        return null;
    }

    public static Boolean isStarBox(Integer type) {
        if (BoxTypeEnum.ONE.type.equals(type)
                || BoxTypeEnum.TWO.type.equals(type)
                || BoxTypeEnum.THREE.type.equals(type)) {
            return true;
        }
        return false;
    }
}
