package cn.com.duiba.tuia.ecb.center.seek.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.common.BaseUserReq;
import cn.com.duiba.tuia.ecb.center.seek.SeekDto;
import cn.com.duiba.tuia.ecb.center.seek.SeekResultDto;
import cn.com.duiba.tuia.ecb.center.seek.req.SeekInitFetchReq;
import cn.com.duiba.tuia.ecb.center.seek.req.SeekJoinReq;

/**
 * 寻宝活动
 * Created by zxw on 2020-09-27.
 */
@AdvancedFeignClient
public interface RemoteSeekService {

    /**
     * 初始化
     *
     * @param userBizReq
     * @return
     */
    SeekDto initialize(BaseUserReq userBizReq) throws BizException;


    /**
     * 初始礼物选择
     *
     * @param req
     * @return
     * @throws BizException
     */
    SeekResultDto initFetch(SeekInitFetchReq req) throws BizException;


    /**
     * 获得额外次数
     *
     * @param userBizReq
     * @return
     */
    String getExtraTimes(BaseUserReq userBizReq) throws BizException;


    /**
     * 摇骰子
     *
     * @param userBizReq
     * @return
     */
    SeekResultDto doJoin(SeekJoinReq userBizReq) throws BizException;


    /**
     * 查询奖励
     *
     * @param userBizReq
     * @return
     */
    Integer queryPrize(BaseUserReq userBizReq) throws BizException;

}
