package cn.com.duiba.tuia.ecb.center.happy.enums;

/**
 * 消消乐抽奖类型
 */
public enum HappyClearPropOriginType {

    BILL_BOARD_AWARD(1, "排行榜"),

    WHEEL(2, "大转盘"),

    RED_PACKET_RAIN(3, "红包雨"),

    EXCHANGE(4, "兑换"),

    PASS_LEVEL(5, "通关"),

    COMPENSATE(6, "补偿"),

    STAR(7, "星星宝箱"),

    SIGN(8, "签到"),

    MISSION(9, "任务"),

    REWARD(10, "回调奖励"),

    ARTIFICIAL(11, "人工接口补偿");


    HappyClearPropOriginType(Integer type, String message) {
        this.type = type;
        this.message = message;
    }

    private Integer type;

    private String message;

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static HappyClearPropOriginType of(Integer type) {
        for (HappyClearPropOriginType propTypeEnum : HappyClearPropOriginType.values()) {
            if (propTypeEnum.getType().equals(type)) {
                return propTypeEnum;
            }
        }
        return null;
    }
}
