package cn.com.duiba.tuia.ecb.center.draw.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.draw.dto.v2.*;
import cn.com.duiba.tuia.ecb.center.draw.req.DrawV2MixUserReq;
import cn.com.duiba.tuia.ecb.center.draw.rsp.v2.DrawV2ActivityComponentRsp;
import cn.com.duiba.tuia.ecb.center.exception.EcbCenterException;
import cn.com.duiba.tuia.ecb.center.mix.req.MixUserReq;

/**
 * @ClassName RemoteDrawV2Service
 * @Description 大转盘2.0
 * @Author Zaizai
 * @Date 2021/3/3 11:19 上午
 **/
@AdvancedFeignClient
public interface RemoteDrawV2Service {

    /**
     * 活动初始化
     * @param mixUserReq
     * @return
     */
    DrawV2ActivityComponentRsp init(MixUserReq mixUserReq) throws BizException;

    /**
     * 参与活动玩法
     * @param mixUserReq
     */
    DrawV2ActivityComponentRsp play(MixUserReq mixUserReq) throws BizException;

    /**
     * 查询奖励发放进度
     * @param mixUserReq
     * @return
     */
    DrawPrizeProgressDTO queryPrizeProgress(MixUserReq mixUserReq) throws BizException;

    /**
     * 开启神秘礼包（新手礼包）
     * @param mixUserReq
     * @return
     */
    DrawV2MysticalGiftOpenDTO openMysticalGift(MixUserReq mixUserReq) throws BizException;

    /**
     * 打开宝箱
     * @param drawV2MixUserReq
     * @return
     */
    DrawV2BoxOpenDTO openBox(DrawV2MixUserReq drawV2MixUserReq) throws BizException;

    /**
     * 查询剩余次数
     * @param mixUserReq
     * @return
     */
    DrawV2SurplusTimesDTO querySurplusTimes(MixUserReq mixUserReq) throws BizException;

    /**
     * 触发看视频答题
     * @param drawV2MixUserReq
     * @return
     * @throws BizException
     */
    VideoAnswerOpenDTO touchVideoAnswer(DrawV2MixUserReq drawV2MixUserReq) throws BizException;

    /**
     * 初始化一个红包金额
     */
    Boolean initRedPaper(MixUserReq req) throws BizException;

}
