package cn.com.duiba.tuia.ecb.center.happy.enums;

/**
 * @author: zdw
 * @Date: 202q/8/02 2:14 下午
 * @Description: 道具类型
 */
public enum HappyClearMissionTypeEnum {

    DAILY(1, "每日任务", 1),
    PERIOD(2, "周期任务", null),
    NEW_USER(3, "新人任务", 19999);


    HappyClearMissionTypeEnum(Integer type, String message, Integer period) {
        this.type = type;
        this.message = message;
        this.period = period;
    }

    private Integer type;

    private String message;

    private Integer period;


    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Integer getPeriod() {
        return period;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public static HappyClearMissionTypeEnum of(Integer type) {
        for (HappyClearMissionTypeEnum propTypeEnum : HappyClearMissionTypeEnum.values()) {
            if (propTypeEnum.getType().equals(type)) {
                return propTypeEnum;
            }
        }
        return null;
    }
}
