package cn.com.duiba.tuia.ecb.center.happy.enums;

/**
 * 消消乐排行榜类型
 */
public enum HappyClearRankTypeEnum {

    DAILY(1, "日排行"),
    WEEK(2, "周排行");


    HappyClearRankTypeEnum(Integer type, String message) {
        this.type = type;
        this.message = message;
    }

    private Integer type;

    private String message;

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static HappyClearRankTypeEnum of(Integer type) {
        for (HappyClearRankTypeEnum propTypeEnum : HappyClearRankTypeEnum.values()) {
            if (propTypeEnum.getType().equals(type)) {
                return propTypeEnum;
            }
        }
        return null;
    }
}
